--------------------------------------------------------------------------------------------------------------
------------------------  One to Many ------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
/*
Generating a batch of SQL code, one line of code per line of the 
result set.

1. Write the SQL statement first.
2. Write the query that pulls the result set you want.
3. Add the command to the query and convert it into to a string.
4. Convert any literals that need to become dynamic into fields.
	a. Double any quotes
	b. Replace anything you want to make dynamic with '++' then plug in the column/formula.
	c. Include schema names
	d. QUOTENAME is your friend.
5. Copy the results to a query window.
6. Test
	a. Parse
	b. Run a SINGLE command, preferrably in a transaction to test for correctness.
	c. Run the rest of the commands in a transaction if possible.
7. After each failed test make one (or sometimes two) corrections and test again.
*/
USE [Dynamic SQL Session];
GO

ALTER TABLE Classes ADD ModifiedDate datetime 
	CONSTRAINT df_Classes_ModifiedDate DEFAULT getdate()

SELECT *
FROM INFORMATION_SCHEMA.TABLES T 
WHERE NOT EXISTS (
	SELECT 1
	FROM INFORMATION_SCHEMA.COLUMNS C
	WHERE COLUMN_NAME = 'ModifiedDate'
	  AND T.TABLE_NAME = C.TABLE_NAME
	  AND T.TABLE_SCHEMA = C.TABLE_SCHEMA
	  )
